/* Copyright (c) 2008 Nordic Semiconductor. All Rights Reserved.
 *
 * The information contained herein is property of Nordic Semiconductor ASA.
 * Terms and conditions of usage are described in detail in NORDIC
 * SEMICONDUCTOR STANDARD SOFTWARE LICENSE AGREEMENT. 
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRENTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 * $LastChangedRevision: 4640 $
 */ 
 
/** @file
 * The RF Safety Shutdown application.
 *
 */

#define CMD_SEND_DATA 0			// Send a new command
#define CMD1 1							// Command-type 1 (Shutdown Command)
#define CMD2 2							// Command-type 2 (No Shutdown Command and Release Panel Mode pin)
#define CMD3 3							// Command-type 3 (Panel Mode Commmand)

#define RF_READY_INT_VECT 9 // Radio interrupt vector

#define DATA_POS 7          // Defines the start-postion of the data in packet. 

#define B0 P00
#define B1 P01
#define TST P02	  //TEST OUTPUT TO LED FOR DEBUG
#define TST2 P03  //TEST OUTPUT TO LED FOR DEBUG
#define TST3 P04  //TEST OUTPUT TO LED FOR DEBUG

#define ON 1
#define OFF 0

/** @addtogroup projects_button_demo
 * @{
 */

/**@brief function to send a packet
@details
This function creates a data_packet from the incoming command and transfers
 *  it to the radio which transmits it. It waits until the packet are sent,
 *  or MAX_RT, i.e. all tries done, then blinks LED0 if the packet was sent,
 *  LED1 otherwise. Finally LED0 is switched off.
 *  @param command data to send.
 */
void send_packet(uint8_t command);

/**@brief This function gets the incoming data from the radio and returns the received command 
 *  @return received data.
 */
uint8_t read_packet(void);

/** @} */

